// GrabItDlg.h : header file
//

#if !defined(AFX_GRABITDLG_H__CACA8D3E_D40C_4198_BEC5_F22180C92F42__INCLUDED_)
#define AFX_GRABITDLG_H__CACA8D3E_D40C_4198_BEC5_F22180C92F42__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Drops.h"
#include "Filter.h"




#define HIMETRIC_INCH	2540	// used in drawing


class CReadThreadParams ;

/////////////////////////////////////////////////////////////////////////////
// CGrabItDlg dialog

class CGrabItDlg : public CDialog
{
// Construction
public:
	CGrabItDlg(CWnd* pParent = NULL);	// standard constructor
	~CGrabItDlg() ;


// Implementation
	CWinThread*	m_thrRead ;
	BOOL		m_Capturing ;
	CReadThreadParams*	m_pPacketInfo ;

	CDrops		m_DropClass ;
	CFilter		m_FilterNEW ;

	BOOL		m_GrabPlayerDrops ;
	BOOL		m_GrabEars ;
	BOOL		m_CheckStartup ;
	char		m_HotKeyOnOff ;
	BOOL		m_GfxLite ;
	BOOL		m_GfxLiteOrig ;
	BOOL		m_Passive ;
	BOOL		m_Penalty ;

	int			m_PriorityColor[5] ;
	int			m_ColorNot ;


	HANDLE		m_diablo2_ph ;
	BOOL		m_DLL_Loaded ;


	BOOL		m_HitSpin ;
	CBitmap		m_buttonbmp[2] ;	// for buttons like runes and gold where text is displayed


	void UpdateRangeGUI( BOOL bInRange) ;
	void ListBoxGUI( int iFilter) ;
	void PreCannedOptions() ;
	void RetrieveOptions() ;
	void SaveOptions() ;


// Dialog Data
	//{{AFX_DATA(CGrabItDlg)
	enum { IDD = IDD_GRABIT_DIALOG };
	CButton	m_bttnUber;
	CStatic	m_RunePic;
	CSliderCtrl	m_slideFilter;
	CSpinButtonCtrl	m_spinRange;
	CButton	m_bttnTP;
	CButton	m_bttnRune;
	CButton	m_bttnRing;
	CButton	m_bttnRejuv;
	CButton	m_bttnMana;
	CButton	m_bttnJewel;
	CButton	m_bttnID;
	CButton	m_bttnHeal;
	CButton	m_bttnCharm;
	CButton	m_bttnGem;
	CButton	m_bttnGold;
	CButton	m_bttnSkull;
	CListBox	m_typeList;
	int		m_iSetRange;
	BOOL	m_checkPick;
	CString	m_sFilterValue;
	int		m_Priority;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGrabItDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;


	// Generated message map functions
	//{{AFX_MSG(CGrabItDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSelchangeTypelist();
	afx_msg void OnKillfocusSetrange();
	afx_msg void OnCheckpick();
	afx_msg void OnDeltaposSpinrange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChangeSetrange();
	afx_msg void OnBttnGold();
	afx_msg void OnBttnHeal();
	afx_msg void OnBttnMana();
	afx_msg void OnBttnRejuv();
	afx_msg void OnBttnRune();
	afx_msg void OnBttnJewlry();
	afx_msg void OnBttnGem();
	afx_msg void OnBttnSkull();
	afx_msg void OnBttnJewel();
	afx_msg void OnBttnCharm();
	afx_msg void OnBttnTP();
	afx_msg void OnBttnID();
	afx_msg void OnDelFilter();
	afx_msg void OnAddFilter();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSaveButton();
	afx_msg void OnHelpButton();
	afx_msg void OnBttnUber();
	afx_msg void OnOptionsButton();
	afx_msg void OnKillfocusPriority();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GRABITDLG_H__CACA8D3E_D40C_4198_BEC5_F22180C92F42__INCLUDED_)
